*-------------------------------------------------------------------------------
*			Appendix IV Fig 2, Appendix IV Fig 4
*-------------------------------------------------------------------------------

** Set Path
global Raw_data    	"G:\project-finished\Descriptive\Data"
global App_data    	"G:\project-finished\Descriptive\Appendix Data"
global Class_data   "G:\project-finished\Descriptive\Classification"  
global Work_lab   	"G:\project-finished\Descriptive\Lab"
global Out_lab    	"G:\project-finished\Descriptive\Out" 

cd "$Work_lab"
                            
capture log close            
log using "$Out_lab\Appendix IV Fig 2, Appendix IV Fig 4", replace 
set more off     

**----------------------------------------------------------------------------**
* Step1: Generate Data
**----------------------------------------------------------------------------**
clear
clear all

//empty file for processed data
set obs 0
save plotdata,replace emptyok


foreach j in "2000" "2010" "2015"{
use "`j'census_consistent.dta",clear

*Define age group
foreach num of numlist 15(5)65{
local age_`num' = `num'
}
egen age_group = cut(age), at(`age_15' `age_20' `age_25' `age_30' `age_35' `age_40' `age_45' `age_50' `age_55' `age_60' `age_65')

*Define edu group
	if `j'==2000{
	tostring educ,gen(edu_level) 

	gen edu=1 if edu_level=="1"|edu_level=="2"|edu_level=="3"|edu_level=="4" 
	replace edu=2 if edu_level=="5" |edu_level=="6"
	replace edu=3 if edu_level=="7" |edu_level=="8" | edu_level=="9"
	}

	if `j'==2010{
	tostring _受教育程度,gen(edu_level) 
	
	gen edu=1 if edu_level=="1"|edu_level=="2"|edu_level=="3"
	replace edu=2 if edu_level=="4" 
	replace edu=3 if edu_level=="5" |edu_level=="6" | edu_level=="7"
	}

	if `j'==2015{
	gen edu=1 if edu_level=="1"|edu_level=="2"|edu_level=="3"
	replace edu=2 if edu_level=="4" |edu_level=="5"
	replace edu=3 if edu_level=="6" |edu_level=="7" | edu_level=="8"
	}


*Industry and occupation
gen occ_ind=consistent+new

gen variety_indocc =.

levelsof age_group
foreach i in `r(levels)'{
	unique occ_ind if age_group==`i'
	replace variety_indocc=`r(unique)' if age_group==`i'
}

*Industry and occupation,by education
gen varietyedu_indocc = .

forvalues e = 1(1)3{

	levelsof age_group
	foreach i in `r(levels)'{
		unique occ_ind if age_group==`i' & edu==`e'
		replace varietyedu_indocc=`r(unique)' if age_group==`i' & edu==`e'
	}
}


*Occupation
gen variety_occ =.

levelsof age_group
foreach i in `r(levels)'{
	unique consistent if age_group==`i'
	replace variety_occ=`r(unique)' if age_group==`i'
}

*Occupation,by education
gen varietyedu_occ=.

forvalues e = 1(1)3{

	levelsof age_group
	foreach i in `r(levels)'{
		unique consistent if age_group==`i' & edu==`e'
		replace varietyedu_occ=`r(unique)' if age_group==`i' & edu==`e'
	}
}

egen variety_indoccmax=max(variety_indocc)
bys edu:egen varietyedu_indoccmax=max(varietyedu_indocc)

egen variety_occmax=max(variety_occ)
bys edu:egen varietyedu_occmax=max(varietyedu_occ)

gen share_occ= variety_occ/ variety_occmax*100
gen share_indocc= variety_indocc / variety_indoccmax*100

gen shareedu_occ= varietyedu_occ/ varietyedu_occmax*100
gen shareedu_indocc= varietyedu_indocc / varietyedu_indoccmax*100

keep share* age_group edu 
duplicates drop

gen year=`j'

append using plotdata
save plotdata,replace
}


**----------------------------------------------------------------------------**
* Step 2:Estimation 
**----------------------------------------------------------------------------**
use plotdata,clear

reshape wide shareedu*,i(age_group year share_occ share_indocc) j(edu)

rename (age_group year) (age period)
gen cohort=period-age

foreach var of varlist share*{

gen b_age`var'=.
gen b_cohort`var'=.
gen b_period`var'=.

apc_ie `var', age(age) period(period) cohort(cohort) 


forvalues a = 15(5)60{
replace b_age`var'=_b[age_`a'] if age==`a'
}

foreach p in "2000" "2010" "2015"{
replace b_period`var'=_b[period_`p'] if period==`p'
}

forvalues c = 1940(5)1995 {
replace b_cohort`var'=_b[cohort_`c'] if cohort==`c'
}
}

keep b_* cohort age period
reshape long b_age b_cohort b_period,i(period age cohort) j(type) string

/*
//Age-Profile----occ
twoway (connected b_age age if type=="share_occ",sort lp(solid) lc(red) mcolor(red) msize(vsmall) msymbol(S)) ///
	(connected b_age age if type=="shareedu_occ1",sort lp(dash) lc(black) mcolor(black) msize(vsmall) msymbol(S)) ///
	(connected b_age age if type=="shareedu_occ2",sort lp(dash_dot) lc(black) mcolor(black) msize(vsmall) msymbol(S)) ///
	(connected b_age age if type=="shareedu_occ3",sort lp(shortdash) lc(black) mcolor(black) msize(vsmall) msymbol(S)) ///
,ytitle("年龄效应") xtitle("年龄段") ylabel(-50(10)50,nogrid)  scheme(plotplain) ///
xlabel(15 "15-19" 20 "20-24" 25 "25-29" 30 "30-34" 35 "35-39" 40 "40-44" 45 "45-49" 50 "50-54" 55 "55-59" 60 "60-64", angle(45)nogrid) ///
legend(label(1 "所有样本") label(2 "低等教育") label(3 "中等教育") label(4 "高等教育") rows(1) position(6)) ///
yline(0) xsize(4) ysize(6)
graph save "$Out_lab\Fig5a",replace
graph export "$Out_lab\Fig5a.png",replace

//Age-Profile----occ and ind
twoway (connected b_age age if type=="share_indocc",sort lp(solid) lc(red) mcolor(red) msize(vsmall) msymbol(S)) ///
	(connected b_age age if type=="shareedu_indocc1",sort lp(dash) lc(black) mcolor(black) msize(vsmall) msymbol(S)) ///
	(connected b_age age if type=="shareedu_indocc2",sort lp(dash_dot) lc(black) mcolor(black) msize(vsmall) msymbol(S)) ///
	(connected b_age age if type=="shareedu_indocc3",sort lp(shortdash) lc(black) mcolor(black) msize(vsmall) msymbol(S)) ///
,ytitle("年龄效应") xtitle("年龄段") ylabel(-50(10)50,nogrid)  scheme(plotplain) ///
xlabel(15 "15-19" 20 "20-24" 25 "25-29" 30 "30-34" 35 "35-39" 40 "40-44" 45 "45-49" 50 "50-54" 55 "55-59" 60 "60-64", angle(45)nogrid) ///
legend(label(1 "所有样本") label(2 "低等教育") label(3 "中等教育") label(4 "高等教育") rows(1) position(6)) ///
yline(0) xsize(4) ysize(6)
graph save "$Out_lab\Fig5b",replace
graph export "$Out_lab\Fig5b.png",replace

*/

//Cohort-Profile
drop if cohort==2000 //2000 lack of obs to esitmate

twoway (connected b_cohort cohort if type=="share_occ",sort lp(solid) lc(black) mcolor(black) msize(small) msymbol(S)) ///
	(connected b_cohort cohort if type=="share_indocc",sort lp(solid) lc(red) mcolor(red) msize(small) msymbol(S)) ///
,ytitle("队列效应") xtitle("出生年代") ylabel(-30(10)30,nogrid)  scheme(plotplain) ///
xlabel(1940 "1936-1940" 1945 "1941-1945" 1950 "1946-1950" 1955 "1951-1955" 1960 "1956-1960" 1965 "1961-1965" 1970 "1966-1970" 1975 "1971-1975" 1980 "1976-1980" 1985 "1981-1985" 1990 "1986-1990" 1995 "1991-1995", angle(45) nogrid) ///
legend(label(1 "职业") label(2 "职业-行业") rows(1) position(6)) ///
 yline(0) 
graph save "$Out_lab\appIV_Fig3a",replace
graph export "$Out_lab\appIV_Fig3a.png",replace

//Cohort-Profile,by education
forvalues e=1(1)3{
twoway (connected b_cohort cohort if type=="shareedu_occ`e'",sort lp(solid) lc(black) mcolor(black) msize(small) msymbol(S)) ///
	(connected b_cohort cohort if type=="shareedu_indocc`e'",sort lp(solid) lc(red) mcolor(red) msize(small) msymbol(S)) ///
,ytitle("队列效应") xtitle("出生年代") ylabel(-30(10)30,nogrid)  scheme(plotplain) ///
xlabel(1940 "1936-1940" 1945 "1941-1945" 1950 "1946-1950" 1955 "1951-1955" 1960 "1956-1960" 1965 "1961-1965" 1970 "1966-1970" 1975 "1971-1975" 1980 "1976-1980" 1985 "1981-1985" 1990 "1986-1990" 1995 "1991-1995", angle(45) nogrid) ///
legend(label(1 "职业") label(2 "职业-行业") rows(1) position(6)) ///
 yline(0) 
graph save "$Out_lab\appIV_Fig3b`e'",replace
graph export "$Out_lab\appIV_Fig3b`e'.png",replace
}


//Period-Profile
gen type_name="职业-行业" if type=="share_indocc"
replace type_name="职业" if type=="share_occ"
graph bar b_period,over(period, gap(0)) over(type_name, gap(100)) scheme(plotplain) ///
ytitle("时期效应") yline(0) ylabel(,nogrid)
graph save "$Out_lab\appIV_Fig4a",replace
graph export "$Out_lab\appIV_Fig4a.png",replace


//Period-Profile,by education
forvalues e=1(1)3{

gen type_name`e'="职业-行业" if type=="shareedu_indocc`e'"
replace type_name`e'="职业" if type=="shareedu_occ`e'"
graph bar b_period,over(period, gap(0)) over(type_name`e', gap(100)) scheme(plotplain) ///
ytitle("时期效应") yline(0) ylabel(,nogrid)
graph save "$Out_lab\appIV_Fig4b`e'",replace
graph export "$Out_lab\appIV_Fig4b`e'.png",replace
}



erase plotdata.dta 
log close



